/*
 * AntennaEntry.cpp
 *
 *  Created on: 16.12.2011
 *      Author: stefan.detter
 */

#include "AntennaEntry.h"

#include "ReaderEntry.h"
#include "TagEntry.h"

AntennaEntry::AntennaEntry(ReaderEntry* reader, uint antennaId)
	: TreeItem(reader)
    , m_reader(reader)
    , m_antennaId(antennaId)
    , m_active(false)
	, m_receivedRfp(false)
	, m_currentRfp(-20)
    , m_hasRfpError(false)
{

}

AntennaEntry::~AntennaEntry()
{
}

void AntennaEntry::inventoryAboutToStart()
{
    m_receivedRfp = false;
    m_hasRfpError = false;

    emit dataChanged(this, COL_ID, COL_State);

    TreeItem::inventoryAboutToStart();
}

void AntennaEntry::inventoryStarted()
{
    TreeItem::inventoryStarted();
}

void AntennaEntry::inventoryStoped()
{
    m_active = false;

    emit dataChanged(this, COL_ID, COL_State);

    TreeItem::inventoryStoped();
}

void AntennaEntry::inventoryPaused()
{
    TreeItem::inventoryPaused();
}

void AntennaEntry::inventoryContinued()
{
    TreeItem::inventoryContinued();
}

uint AntennaEntry::antennaId () const
{
    return m_antennaId;
}

void AntennaEntry::setActive(bool active)
{
    m_active = active;
}

void AntennaEntry::setReflectedPowerError(bool error, int value)
{
    m_receivedRfp = error;
    m_currentRfp = value / 100.0;
    m_hasRfpError = error;
}

void AntennaEntry::setReflectedPowerValue(int value)
{
	m_receivedRfp = true;
	m_currentRfp = value / 100.0;
    m_hasRfpError = false;
}


void AntennaEntry::removeRSSI()
{
	foreach(TreeItem* t, m_children)
	{
		if(dynamic_cast<TagEntry*>(t) != 0)
			dynamic_cast<TagEntry*>(t)->removeRSSI();
	}
}

void AntennaEntry::removeReadFrequency()
{
	foreach(TreeItem* t, m_children)
	{
		if(dynamic_cast<TagEntry*>(t) != 0)
			dynamic_cast<TagEntry*>(t)->removeReadFrequency();
	}
}

int	AntennaEntry::tagCount() const
{
    return m_tagIndex.size();
}

QSet<QString> AntennaEntry::uniqueTagIds() const
{
    return m_tagIndex.keys().toSet();
}

bool AntennaEntry::containsTag ( const QString& tagId ) const
{
	return m_tagIndex.contains(tagId);
}

TagEntry* AntennaEntry::tag ( const QString& tagId ) const
{
	return (TagEntry*)m_tagIndex.value(tagId);
}

TagEntry* AntennaEntry::appendTag ( const QString& type, const QString& tagId, const QString& visualTagId)
{
	emit beginInsertRows(this, m_tagIndex.size(), m_tagIndex.size() );

    TagEntry* t = new TagEntry(this, m_reader, this, type, tagId, visualTagId);
	m_children.append(t);
	m_tagIndex.insert(tagId, t);

	connectChild(t);

	connect(t, 		SIGNAL(shouldBeRemoved(const QString&)),
			this, 	  SLOT(removeTag(const QString&)) );

	emit endInsertRows();
	emit requestToExpand(this);
	emit updateInformation();


	return t;
}

void AntennaEntry::removeTag ( const QString& tagId )
{
	if(m_tagIndex.contains(tagId))
	{
		TagEntry* t = dynamic_cast<TagEntry*>(m_tagIndex.value(tagId));

		if(t == 0)
			return;

		emit aboutToBeRemoved(t);

		emit beginRemoveRows( this, m_children.indexOf(t), m_children.indexOf(t) );
		m_children.removeAt(m_children.indexOf(t));
		m_tagIndex.remove(tagId);
		emit endRemoveRows();

		delete t;

		emit updateInformation();
	}
}


void AntennaEntry::updateDynamicInfo()
{
    emit dataChanged(this, COL_Action, COL_State);

	TreeItem::updateDynamicInfo();
}

void AntennaEntry::clearTags()
{
	foreach(QString tagId, m_tagIndex.keys())
	{
		removeTag(tagId);
	}

	// Not needed
	//TreeItem::clearTags();
}
